/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xexerdef.h 
 *       Type Definitions for Exerciser Functions
 * -----------------------------------------------------------------*/

#ifndef XEXERCISERDEFS_H_INCLUDED                               
#define XEXERCISERDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif

/********************************************************************
  Exerciser generics ************************************************
 *******************************************************************/

#define BX_EGENPROP_SIZE     25

CLI typedef enum {
  BX_EGEN_COMPLIANT,     /* @compliant    */
  BX_EGEN_ERR_SOURCE,    /* @errsource    */
  BX_EGEN_ERR_NUM,       /* @errnum       */ /* decoder num resp. memory offset; range depends on SOURCE */
  BX_EGEN_ERR_PHASE,     /* @errphase     */
  BX_EGEN_ERR_WRPAR,     /* @errwrpar     */
  BX_EGEN_ERR_WRPAR64,   /* @errwrpar64   */
  BX_EGEN_ERR_PERR,      /* @errperr      */
  BX_EGEN_ERR_SERR,      /* @errserr      */
  BX_EGEN_ERR_ECC,       /* @errecc       */
  BX_EGEN_ERR_SUBPHASE,  /* @errsubphase  */
  BX_EGEN_INT_SOURCE,    /* @intsource    */
  BX_EGEN_INT_NUM,       /* @intnum       */
  BX_EGEN_INT_DELAYA,    /* @intdelaya    */
  BX_EGEN_INT_DELAYB,    /* @intdelayb    */
  BX_EGEN_INT_DELAYC,    /* @intdelayc    */
  BX_EGEN_INT_DELAYD,    /* @intdelayd    */
  BX_EGEN_TRIG_SOURCE,   /* @trigsource   */
  BX_EGEN_TRIG_NUM,      /* @trignum      */
  BX_EGEN_ARB,           /* @arb          */   
  BX_EGEN_ARBRI,         /* @arbri        */
  BX_EGEN_ARBCI,         /* @arbci        */
  BX_EGEN_DATAGEN,       /* @datagen      */
  BX_EGEN_DATAFIX,       /* @datafix      */
  BX_EGEN_PARTCOMP,      /* @partcomp     */
  BX_EGEN_DATASEED       /* @dataseed     */
} bx_egentype;


CLI  /* DEF_START ~G_BX_EGEN_TRIG_SOURCE */
#define BX_EGEN_TRIG_SOURCE_NONE   0   /* no trigger generation at all */
#define BX_EGEN_TRIG_SOURCE_RIBLK  1
#define BX_EGEN_TRIG_SOURCE_RIBEH  2
#define BX_EGEN_TRIG_SOURCE_CTBEH  3
#define BX_EGEN_TRIG_SOURCE_CIBEH  4
#define BX_EGEN_TRIG_SOURCE_RTBEH  5
#define BX_EGEN_TRIG_SOURCE_DEC    6
CLI /* DEF_END */

CLI /* DEF_START ~G_BX_EGEN_INT_SOURCE */
#define BX_EGEN_INT_SOURCE_NONE   0   /* no interrupt generation at all */
#define BX_EGEN_INT_SOURCE_RIBLK  1
#define BX_EGEN_INT_SOURCE_RIBEH  2
#define BX_EGEN_INT_SOURCE_CTBEH  3
#define BX_EGEN_INT_SOURCE_CIBEH  4
#define BX_EGEN_INT_SOURCE_RTBEH  5
#define BX_EGEN_INT_SOURCE_DEC    6
#define BX_EGEN_INT_SOURCE_RIDONE 7   /* Faust only */
CLI /* DEF_END */

CLI /* DEF_START ~G_BX_EGEN_ERR_SOURCE */
#define BX_EGEN_ERR_SOURCE_NONE  0   /* no error generation at all */
#define BX_EGEN_ERR_SOURCE_RIBLK 1
#define BX_EGEN_ERR_SOURCE_RIBEH 2
#define BX_EGEN_ERR_SOURCE_CTBEH 3
#define BX_EGEN_ERR_SOURCE_CIBEH 4
#define BX_EGEN_ERR_SOURCE_RTBEH 5
#define BX_EGEN_ERR_SOURCE_DEC   6
CLI /* DEF_END */

CLI /* DEF_START ~G_BX_EGEN_INT_DELAY */
#define BX_EGEN_INT_DELAY_NO 0
CLI /* DEF_END */

CLI /* DEF_START ~G_BX_EGEN_ARB */
#define BX_EGEN_ARB_AUTO  0
#define BX_EGEN_ARB_CONST 1
#define BX_EGEN_ARB_INCR  2
#define BX_EGEN_ARB_RAND  3
CLI /* DEF_END */

CLI /* DEF_START ~G_BX_EGEN_ERR_PHASE */
#define BX_EGEN_ERR_PHASE_ADDR 0
/* 1,..,0x400 means PHASE_DATA */
#define BX_EGEN_ERR_PHASE_ATTR 0x401
CLI /* DEF_END */

CLI /* DEF_START ~G_BX_EGEN_DATAGEN */
#define BX_EGEN_DATAGEN_WALKING0     0
#define BX_EGEN_DATAGEN_WALKING1     1
#define BX_EGEN_DATAGEN_COUNTER      2
#define BX_EGEN_DATAGEN_COUNTMIX     3
#define BX_EGEN_DATAGEN_GROUNDBOUNCE 4
CLI /* DEF_END */

CLI /* DEF_START ~G_BX_EGEN_DATAFIX */
#define BX_EGEN_DATAFIX_MASTERID 0x40000
CLI /* DEF_END */

CLI /* DEF_START ~G_BX_EGEN_PARTCOMP */
#define BX_EGEN_PARTCOMP_ON  1
#define BX_EGEN_PARTCOMP_OFF 0
CLI /* DEF_END */

/********************************************************************
  Exerciser memories ************************************************
 *******************************************************************/

CLI typedef enum {
  BX_EMEM_RIBLK=0,     /* @riblk */
  BX_EMEM_RIBEH=1,     /* @ribeh */
  BX_EMEM_CTBEH=2,     /* @ctbeh */
  BX_EMEM_CIBEH=3,     /* @cibeh */
  BX_EMEM_RTBEH=4,     /* @rtbeh */
  BX_EMEM_ENUMSIZE     /* $enumsize */
} bx_ememtype;

/* How ExerciserRead() executes */
#define BX_EXEREAD_CARD   0
#define BX_EXEREAD_ALL    1
#define BX_EXEREAD_NONE   2
#define BX_EXEREAD_USER   3

#endif
